data:extend(
{
  {
    type = "recipe-category",
    name = "fluid-furnace"
  },
  {
    type = "recipe",
    name = "light-oil-to-petroleum-gas",
    category = "fluid-furnace",
    enabled = true,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="light-oil", amount=1}
    },
    results=
    {
      {type="fluid", name="petroleum-gas", amount=4}
    },
    subgroup = "fluid",
    order = "a[oil-processing]-a[advance-light-oil-processing]"
  },
  {
    type = "recipe",
    name = "heated-light-oil-to-heated-petroleum-gas",
    category = "crafting-with-fluid",
    enabled = true,
    energy_required = 1,
    ingredients =
    {
      {type="fluid", name="light-oil", amount=1, minimum_temperature = 75, maximum_temperature = 90}
    },
    results =
    {
      {type="fluid", name="petroleum-gas", amount=1, temperature=80}
    },
    subgroup = "fluid",
    order = "a[oil-processing]-a[heated-light-oil-processing]"
  },
  {
    type = "recipe",
    name = "probabilistic-crusher",
    icon = "__base__/graphics/icons/uranium-processing.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "crafting",
    enabled = true,
    energy_required = 0.01,
    ingredients =
    {
      {type="item", name="iron-plate", amount=1},
      {type="item", name="iron-gear-wheel", amount=1, catalyst_amount=1}
    },
    results =
    {
      {type="item", name="iron-ore", amount=1},
      {type="item", name="iron-gear-wheel", amount=1, catalyst_amount=1, probability= 0.5}
    },
    subgroup = "raw-material",
    order = "xxx"
  },
  {
    type = "recipe",
    name = "processing-with-2-fluid-index",
    icon = "__base__/graphics/icons/uranium-processing.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "oil-processing",
    enabled = true,
    energy_required = 1,
    ingredients =
    {
      {type="fluid", name="crude-oil", amount = 1}
    },
    results =
    {
      {type="fluid", name="heavy-oil", amount = 4, fluidbox_index = 1},
      {type="fluid", name="petroleum-gas", amount = 4, fluidbox_index = 3}
    },
    subgroup = "fluid",
    order = "a[oil-processing]-c[desync]"
  },
  {
    type = "recipe",
    name = "alot-of-output-so-fluidbox-volume-increases",
    category = "chemistry",
    enabled = true,
    energy_required = 1,
    ingredients =
    {
      {type="fluid", name="light-oil", amount=1000}
    },
    results=
    {
      {type="fluid", name="petroleum-gas", amount=1000}
    },
    subgroup = "fluid",
    order = "a[oil-processing]-a[heated-light-oil-processing]"
  },
  {
    type = "recipe",
    name = "consume-iron-when-some-but-not-all-catalyst-returned",
    ingredients =
    {
      {type="item", name="iron-plate", amount=3, catalyst_amount=3}
    },
    results = {
      {type="item", name="iron-plate", amount=1, catalyst_amount=3}
    }
  }
})
