/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mezz.jei.color.ColorUtil;
import org.jetbrains.annotations.Nullable;

public class ColorNamer {
    private final ImmutableMap<Integer, String> colorNames;

    public ColorNamer(ImmutableMap<Integer, String> colorNames) {
        this.colorNames = colorNames;
    }

    public Stream<String> getColorNames(Iterable<Integer> colors) {
        return StreamSupport.stream(colors.spliterator(), false).mapMulti((color, consumer) -> {
            String colorName = this.getClosestColorName((Integer)color);
            if (colorName != null) {
                consumer.accept(colorName);
            }
        }).distinct();
    }

    @Nullable
    private String getClosestColorName(Integer color) {
        return this.colorNames.entrySet().stream().min(Comparator.comparing(entry -> {
            Integer namedColor = (Integer)entry.getKey();
            double distance = ColorUtil.slowPerceptualColorDistanceSquared(namedColor, color);
            return Math.abs(distance);
        })).map(Map.Entry::getValue).orElse(null);
    }
}

